<?php

namespace App\Notifications;

use App\Models\ForumPost;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PostReactionNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $reactor;
    protected $post;
    protected $reactionType;

    /**
     * Create a new notification instance.
     */
    public function __construct(User $reactor, ForumPost $post, string $reactionType)
    {
        $this->reactor = $reactor;
        $this->post = $post;
        $this->reactionType = $reactionType;
    }

    /**
     * Get the notification's delivery channels.
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     */
    public function toDatabase(object $notifiable): array
    {
        return [
            'reactor_id' => $this->reactor->id,
            'reactor_name' => $this->reactor->name,
            'reactor_avatar' => $this->reactor->avatar,
            'post_id' => $this->post->id,
            'post_content_preview' => \Illuminate\Support\Str::limit(strip_tags($this->post->content), 100),
            'thread_id' => $this->post->thread->id,
            'thread_title' => $this->post->thread->title,
            'thread_slug' => $this->post->thread->slug,
            'board_slug' => $this->post->thread->board->slug,
            'reaction_type' => $this->reactionType,
            'reaction_emoji' => \App\Models\ForumReaction::getTypes()[$this->reactionType] ?? '',
            'message' => "{$this->reactor->name} reacted to your post in \"{$this->post->thread->title}\"",
            'url' => route('forum.thread', [$this->post->thread->board->slug, $this->post->thread->slug]) . '#post-' . $this->post->id
        ];
    }
}